// suspenddatatoolbar.js
//
// This file acts as an interface for the Toolbar
// to interact with the suspendData VarStore object 
// that resides in the toolbar frame.
//
// Developers should not interact with suspendData object
// directly, instead they should use the interface
// functions provided in this file to set/get/remove
// name, value pairs.


// Sets a persistent variable's value. 
function setVar(tok,val)
{
	if (sizeOk())
	{
		var value = suspendData.setValue(tok,val);
		if (value && suspendData.dirty)
		{
			if (sizeOk())
			{
				LMSSetValue("cmi.suspend_data",suspendData.dump());
			}
			else
			{
				removeVar(tok);
				alert("suspendData has exceeded it's capacity!");
				value = false;				
			}
		}
		return value;
	}
	else
	{
		alert("suspendData has exceeded it's capacity!");
		return false;
	}
}

// Gets a persistent variable's value. 
function getVar(tok)
{
	return suspendData.getValue(tok);
}

// Removes a persistent variable. 
function removeVar(tok)
{
	var value = suspendData.remove(tok);
	if (value && suspendData.dirty)
	{
		LMSSetValue("cmi.suspend_data",suspendData.dump());
	}
	return value;
}

function sizeOk()
{
	if (suspendData.dump().length > 4096)
	{
		return false;
	}
	else
	{
		return true;
	}
}

function getSuspendDataSize()
{
	return suspendData.dump().length;
}



